document.addEventListener('DOMContentLoaded', function () {
    const input = document.getElementById('store_address');
    if (!input || typeof google === 'undefined') return;

    const autocomplete = new google.maps.places.Autocomplete(input, { types: ['geocode'] });

    autocomplete.addListener('place_changed', function () {
        const place = autocomplete.getPlace();
        if (!place.address_components) return;

        let city = '', city_code = '', state = '', state_code = '', country = '', country_code = '', postal_code = '';

        place.address_components.forEach(component => {
            const types = component.types;

            if (types.includes('locality')) {
                city = component.long_name;
                city_code = component.short_name;
            }
            if (types.includes('administrative_area_level_1')) {
                state = component.long_name;
                state_code = component.short_name;
            }
            if (types.includes('country')) {
                country = component.long_name;
                country_code = component.short_name;
            }
            if (types.includes('postal_code')) {
                postal_code = component.long_name;
            }
        });
        // Set the full formatted address
        input.value = place.formatted_address || '';

        document.getElementById('store_city').value = city;
        document.getElementById('store_city_code').value = city_code;

        document.getElementById('store_state').value = state;
        document.getElementById('store_state_code').value = state_code;

        document.getElementById('store_country').value = country;
        document.getElementById('store_country_code').value = country_code;

        document.getElementById('store_postal_code').value = postal_code;
    });
});
