<?php
// class Custom_Frontend_Display {
//     public static function display_quote() {
//         error_log('enter into display_quote');
//         $quotes = WC()->session->get('custom_quote');
//         if (empty($quotes) || !is_array($quotes)) return;

//         echo '<div class="custom-quotes">';
//         echo '<h3>Shipping Options</h3>';

//         foreach ($quotes as $quote) {
//             echo '<div class="custom-quote" style="margin-bottom: 15px; padding: 10px; border: 1px solid #ccc;">';
            
//             echo '<p><strong>Service:</strong> ' . esc_html($quote['provider']['name']) . '</p>';
//             echo '<p><strong>Price:</strong> ' . wc_price($quote['freight']) . '</p>';
//             $delivery_text = ($quote['delivery_time'] === 0) ? 'Today' : $quote['delivery_time'] . ' days';
            
//             echo '<p><strong>Estimated Delivery:</strong> ' . esc_html($delivery_text) . '</p>';
           
//             // Uncomment if image exists:
//             if (!empty($quote['provider']['image'])) {
//                 echo '<img src="' . esc_url($quote['provider']['image']) . '" alt="Shipping Option" style="max-width:100px;">';
//             }
//             echo '</div>';
//         }

//         echo '</div>';
//     }
// }

class Custom_Frontend_Display {
    public static function init222() {
       // add_action('wp_footer', [__CLASS__, 'inject_quote_into_shipping_options']);
    }

    public static function init() {
        add_action('wp_footer', [__CLASS__, 'inject_quote_into_shipping_options']);
    }

    public static function get_quote_html33() {
        $quotes = WC()->session->get('custom_quote');
        if (empty($quotes) || !is_array($quotes)) return '------------------@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@';

        ob_start();
        echo '<div class="custom-quotes">';
        echo '<h3>Shipping Options</h3>';
        error_log('Quote info 333333:'. json_encode($quotes['data']));
        foreach ($quotes['data'] as $quote) {
            error_log('Quote info :'. json_encode($quote));
            echo '<div class="custom-quote d-flex" style="margin-bottom: 15px; padding: 10px; border: 1px solid #ccc;">';
            if (!empty($quote['provider']['image'])) {
                echo '<img src="' . esc_url($quote['provider']['image']) . '" alt="Shipping Option" style="max-width:100px;">';
            }
            echo '<p><strong>Service:</strong> ' . esc_html($quote['provider']['name']) . '</p>';
            echo '<p><strong>Price:</strong> ' . wc_price($quote['freight']) . '</p>';
            $delivery_text = ($quote['delivery_time'] === 0) ? 'Today' : $quote['delivery_time'] . ' days';
            echo '<p><strong>Estimated Delivery:</strong> ' . esc_html($delivery_text) . '</p>';
            
            echo '</div>';
        }

        echo '</div>';
        return ob_get_clean();
    }
    public static function get_quote_html() {
        $quotes = WC()->session->get('custom_quote');
        if (empty($quotes) || !is_array($quotes)) return 'No quotes available.';
    
        ob_start();
        echo '<div class="custom-quotes" style="margin-bottom:20px;">';
        echo '<h4>Shipping Options</h4>';
    
        // Add the style block
        echo '<style>
            .quote-card {
              display: flex;
              align-items: center;
              gap: 20px;
              padding: 10px;
              border: 1px solid #ddd;
              border-radius: 12px;
              margin-bottom: 5px;
              background-color: #f9f9f9;
              box-shadow: 0 2px 8px rgba(0,0,0,0.05);
            }
    
            .quote-card img {
              max-width: 100px;
              border-radius: 8px;
            }
    
            .quote-details {
              display: flex;
              flex-direction: row;
              flex-wrap: wrap;
              gap: 30px;
            }
    
            .quote-detail {
              font-size: 16px;
            }
    
            @media (max-width: 768px) {
              .quote-card {
                flex-direction: column;
                text-align: center;
              }
    
              .quote-details {
                flex-direction: column;
                align-items: center;
              }
    
              .quote-card input[type="radio"] {
                align-self: center;
              }
            }
        </style>';
    
        // Loop through quotes
        foreach ($quotes['data'] as $quote) {
            $provider_name = esc_html($quote['provider']['name']);
            $price = wc_price($quote['freight']);
            $delivery_text = ($quote['delivery_time'] === 0) ? 'Today' : esc_html($quote['delivery_time']) . ' days';
            $image_url = !empty($quote['provider']['image']) ? esc_url($quote['provider']['image']) : 'https://via.placeholder.com/100';
    
            echo '<div class="quote-card">';
            echo '<input type="radio" name="shipping_option" class="form-check-input" value="' . esc_attr($provider_name) . '" />';
            echo '<img src="' . $image_url . '" alt="Provider Image">';
            echo '<div class="quote-details">';
            echo '<div class="quote-detail">' . $provider_name . '</div>';
            echo '<div class="quote-detail"><strong>Price:</strong> ' . $price . '</div>';
            echo '<div class="quote-detail"><strong>Delivery:</strong> ' . $delivery_text . '</div>';
            echo '</div>';
            echo '</div>';
        }
    
        echo '</div>'; // .custom-quotes
        return ob_get_clean();
    }
    
    
    public static function get_quote_html_old() {
        $quotes = WC()->session->get('custom_quote');
        if (empty($quotes) || !is_array($quotes)) return '------------------@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@';
    
        ob_start();
        echo '<div class="custom-quotes">';
        echo '<h4>Shipping Options</h4>';
    
        error_log('Quote info 333333:' . json_encode($quotes['data']));
    
        foreach ($quotes['data'] as $quote) {
            error_log('Quote info :' . json_encode($quote));
    
            echo '<div class="custom-quote d-flex align-items-center gap-4 mb-3 p-3 border rounded">';
            
            // Image
            if (!empty($quote['provider']['image'])) {
                echo '<div class="flex-shrink-0">';
                echo '<img src="' . esc_url($quote['provider']['image']) . '" alt="Shipping Option" style="max-width: 100px;" />';
                echo '</div>';
            }
    
            // Price & Info
            echo '<div>';
            echo '<p class="mb-1"><strong>Service:</strong> ' . esc_html($quote['provider']['name']) . '</p>';
            echo '<p class="mb-1 text-primary"><strong>Price:</strong> ' . wc_price($quote['freight']) . '</p>';
            $delivery_text = ($quote['delivery_time'] === 0) ? 'Today' : $quote['delivery_time'] . ' days';
            echo '<p class="mb-0"><strong>Estimated Delivery:</strong> ' . esc_html($delivery_text) . '</p>';
            echo '</div>';
    
            echo '</div>'; // end .custom-quote
        }
    
        echo '</div>'; // end .custom-quotes
        return ob_get_clean();
    }
    
    public static function inject_quote_into_shipping_options222($rate, $index) {
        
            echo self::get_quote_html();
        
    }

    public static function inject_quote_into_shipping_options() {
        if (!is_checkout()) return;
    
        $html = self::get_quote_html();
        if (!$html) return;
    
        error_log('inject_quote_into_shipping_options method called');
        ?>
       <script type="text/javascript">
            // jQuery(document).ready(function($) {
            //     $(document.body).on('#checkbox-control-2','click', function () {
            //         alert('111111');
            //         var target = document.querySelector('.woocommerce-shipping-methods');
            //         if (target && !document.getElementById('my-custom-shipping')) {
            //             alert('2222222');
            //             target.insertAdjacentHTML('beforebegin', <?php // echo json_encode($html); ?>);
            //         }
            //     });
            // });
            function loadQuotes() {
                var target = document.getElementById('billing-fields');
                console.log(target);
                if (target) {
                    target.insertAdjacentHTML('beforebegin', <?php echo json_encode($html); ?>);
                }
            }
            document.addEventListener('DOMContentLoaded', function () {
                        //loadQuotes();
                        setTimeout(loadQuotes, 3000);
            });
        </script>

        <?php
    }
    
}

