<?php
class Custom_API_Handler {
    private static $token_key = 'oes_api_access_token';
    private static $api_key = 'AIzaSyDpdNGnKRQ5lzRm9BB6PHSwYP9t5AUxb_k';

    // Fetch the token only if it doesn't exist in the session
   // Your existing methods below

public static function oes_fetch_token() {
    global $woocommerce;

    $woocommerce->session->set('oes_shipping', true);

    if (!class_exists('WooCommerce') || !WC()->session) {
        error_log('WooCommerce or session not available');
        return;
    }

    $token = WC()->session->get(self::$token_key);
    $token_expiry = WC()->session->get('oes_token_expiry');
    $now = time();

    if (!$token || !$token_expiry || $now >= $token_expiry) {
        $store_origin = get_option('oes_store_address', []);
        $response = wp_remote_post('https://staging-api.oneeasystop.com/api/accesstoken', [
            'headers' => [
                'Content-Type' => 'application/json',
                'Accept' => 'application/json',
            ],
            'body' => json_encode([
                'client_id' => $store_origin['client_id'] ?? '',
                'client_secret' => $store_origin['client_secret'] ?? '',
                'grant_type' => 'client_credentials',
            ]),
        ]);

        if (is_wp_error($response)) {
            error_log('OES Token request error: ' . $response->get_error_message());
            return;
        }

        $body = json_decode(wp_remote_retrieve_body($response), true);

        if (!empty($body['access_token'])) {
            $new_token = $body['access_token'];
            $expires_in = 3600;

            WC()->session->set(self::$token_key, $new_token);
            WC()->session->set('oes_token_expiry', $now + $expires_in - 60);
    
        } else {
            error_log('Invalid token response: ' . print_r($body, true));
        }
    } else {
        //error_log('Access token is valid, no need to fetch.');
    }

    WC()->session->set('token_fetched', true);
}

public static function oes_get_quote() {
    
    if (!class_exists('WooCommerce') || !WC()->session) {
        error_log('WooCommerce or session not available');
        return;
    }

    $quote_hash = md5(json_encode(WC()->cart->get_cart()) . json_encode(WC()->customer->get_shipping()));

    if (WC()->session->get('quote_hash') === $quote_hash) {
        //error_log('Quote already fetched for current cart/address');
        //return;
    }

    WC()->session->set('quote_hash', $quote_hash);

    $token = WC()->session->get(self::$token_key);
    if (!$token) {
        error_log('No token found in session');
        return;
    }

    $cart = WC()->cart->get_cart();
    $values = [];

    foreach ($cart as $item) {
        $product = wc_get_product($item['product_id']);
        if (!$product) continue;

        // product dimentions for oes 

        $product_id = $product->get_id();

        // Get custom meta values (or null if not set)
        $length = get_post_meta($product_id, '_package_length', true) ?: null;
        $width  = get_post_meta($product_id, '_package_width', true) ?: null;
        $height = get_post_meta($product_id, '_package_height', true) ?: null;
        $weight = get_post_meta($product_id, '_package_weight', true) ?: null;
        $declared_value = get_post_meta($product_id, '_declared_value', true) ?: null;
    
        $values[] = [
            'tmpId'                 => 1,
            'long'                  => floatval($length ?? $product->get_length()),
            'height'                => floatval($height ?? $product->get_height()),
            'wide'                  => floatval($width ?? $product->get_width()),
            'weight'                => floatval($weight ?? $product->get_weight()),
            'service'               => 1,
            'description'           => $product->get_name(),
            'currency_id'           => 1,
            'value'                 => floatval($declared_value ?? $product->get_price()),
            'delivery_payment_type' => 1,
            'quantity'              => $item['quantity'],
        ];
            
        //end dimentions

        //old code
        // $values[] = [
        //     'tmpId' => 1,
        //     'long' => floatval($product->get_length()),
        //     'height' => floatval($product->get_height()),
        //     'wide' => floatval($product->get_width()),
        //     'weight' => floatval($product->get_weight()),
        //     'service' => 1,
        //     'description' => $product->get_name(),
        //     'currency_id' => 1,
        //     'value' => floatval($product->get_price()),
        //     'delivery_payment_type' => 1,
        //     'quantity' => $item['quantity'],
        // ];
        // end old code
    }

    if (empty($values)) {
        error_log('Cart is empty or no valid products');
        return;
    }

    $address = WC()->customer->get_shipping();
    
    if (empty($address['postcode']) || empty($address['city']) || empty($address['country'])) {
        error_log('Shipping address incomplete');
        return;
    }

    $place_id = self::wcd_get_place_id($address['city'], self::$api_key);
    $location_details = [];
    if ($place_id) {
        $components = self::wcd_get_address_components($place_id, self::$api_key);
        $location_details = self::wcd_parse_address_components($components);
    }

    $store_origin = get_option('oes_store_address', []);

    $request_data = [
        'quotation' => [
            'data' => [
                'fromCountry'            => $store_origin['country'] ?? '',
                'fromCountryCode'        => $store_origin['country_code'] ?? '',
                'fromState'              => $store_origin['state'] ?? '',
                'fromStateCode'          => $store_origin['state_code'] ?? '',
                'fromCity'               => $store_origin['city'] ?? '',
                'fromCityCode'           => $store_origin['city_code'] ?? '',
                'from_zip'               => $store_origin['postal_code'] ?? '',
                'toCountry'              => $location_details['country'] ?? $address['country'],
                'toCountryCode'          => $location_details['country_code'],
                'toState'                => $location_details['state'],
                'toStateCode'            => $location_details['state_code'],
                'toCity'                 => $location_details['city'],
                'toCityCode'             => $location_details['city_code'],
                'to_zip'                 => $location_details['postcode'] ?? $address['postcode'],
                'magnitude'              => 2,
                'delivery_fast'          => 0,
                'cheaper'                => true,
                'extra_charges'          => 0,
                'extra_charges_currency' => 1,
                'extra_description'      => '',
                'date_of_quote'          => date('Y-m-d'),
                'city'                   => true,
            ],
            'values' => $values
        ]
    ];

    if ($location_details['country_code'] != $request_data['quotation']['data']['fromCountryCode']) {
        $request_data['quotation']['data']['magnitude'] = 1;
    }

    $response = wp_remote_post('https://staging-api.oneeasystop.com/api/quotes', [
        'timeout' => 60,
        'headers' => [
            'Authorization' => 'Bearer ' . $token,
            'Content-Type'  => 'application/json',
            'Accept'        => 'application/json',
        ],
        'body' => json_encode($request_data),
    ]);

    if (is_wp_error($response)) {
        error_log('Quote request failed: ' . $response->get_error_message());
        return;
    }

    $body = json_decode(wp_remote_retrieve_body($response), true);

    if (!empty($body['quotations'])) {
        WC()->session->set('custom_quote', $body['quotations']);
    } else {
        error_log('Quote response invalid: ' . print_r($body, true));
    }
}

// Function to get place ID from Google Places API
public static function wcd_get_place_id($city_name, $api_key) {
    $url = 'https://maps.googleapis.com/maps/api/place/findplacefromtext/json?' . http_build_query([
        'input' => $city_name,
        'inputtype' => 'textquery',
        'fields' => 'place_id',
        'key' => $api_key
    ]);

    $response = wp_remote_get($url);
    $data = json_decode(wp_remote_retrieve_body($response), true);

    if (!empty($data['candidates'][0]['place_id'])) {
        return $data['candidates'][0]['place_id'];
    }
    return null;
}

// Function to get address components from place ID
public static function wcd_get_address_components($place_id, $api_key) {
    $url = 'https://maps.googleapis.com/maps/api/place/details/json?' . http_build_query([
        'place_id' => $place_id,
        'fields' => 'address_component',
        'key' => $api_key
    ]);

    $response = wp_remote_get($url);
    $data = json_decode(wp_remote_retrieve_body($response), true);

    if (!empty($data['result']['address_components'])) {
        return $data['result']['address_components'];
    }
    return [];
}

// Parse address components to extract city, state, country, and their codes
public static function wcd_parse_address_components($components) {
    $location = [
        'city' => '',
        'city_code' => '',
        'state' => '',
        'state_code' => '',
        'country' => '',
        'country_code' => ''
    ];

    foreach ($components as $component) {
        $types = $component['types'];

        if (in_array('locality', $types)) {
            $location['city'] = $component['long_name'];
            $location['city_code'] = $component['short_name'];
        }
        if (in_array('administrative_area_level_1', $types)) {
            $location['state'] = $component['long_name'];
            $location['state_code'] = $component['short_name'];
        }
        if (in_array('country', $types)) {
            $location['country'] = $component['long_name'];
            $location['country_code'] = $component['short_name'];
        }
    }

    return $location;
}
public static function oes_create_shipment_after_payment($order_id) {
    WC()->session->set('shipment_order_id', $order_id);

    if(WC()->session->get('shipment_order_id') == $order_id && WC()->session->get('shipment_order_status') == 'created'){
        //error_log('alredy shipment created for order_id : '.$order_id);
        return;
    }
    
    if (!$order_id) return;
    
    $order = wc_get_order($order_id);
    if (!$order) return;

    $shipping_methods = $order->get_shipping_methods();
    $shipping_data = array_values($shipping_methods)[0] ?? null;
    $selected_option_id = $shipping_data ? $shipping_data->get_meta('oes_option_id') : null;
    $oes_order_id = $shipping_data ? $shipping_data->get_meta('oes_order_id') : null;
    $full_quote_data = $shipping_data ? $shipping_data->get_meta('quote_info') : null;

    // Check if this order used our custom method
    //if (strpos($chosen_method, 'Custom API Shipping') === false) return;

    $shipping_items = $order->get_items('shipping');
    //$shipping_data = [];

    // foreach ($shipping_items as $item) {
    //     $shipping_data = $item->get_data();
    //     break;
    // }

    $selected_label = $shipping_data['name']; // ex: "FedEx - Priority"
    $shipping_meta = $shipping_data['meta_data'];

    // Get delivery time if available
    // $delivery_time = '';
    // foreach ($shipping_meta as $meta) {
    //     if ($meta->key === 'delivery_time') {
    //         $delivery_time = $meta->value;
    //     }
    // }

    // Prepare shipment request payload
    // $shipment_payload = [
    //     'order_id' => $order->get_id(),
    //     'customer_name' => $order->get_shipping_first_name() . ' ' . $order->get_shipping_last_name(),
    //     'address' => [
    //         'line1'   => $order->get_shipping_address_1(),
    //         'line2'   => $order->get_shipping_address_2(),
    //         'city'    => $order->get_shipping_city(),
    //         'state'   => $order->get_shipping_state(),
    //         'postcode'=> $order->get_shipping_postcode(),
    //         'country' => $order->get_shipping_country(),
    //     ],
    //     'carrier' => $selected_label,
    //     'delivery_time' => $delivery_time,
    // ];

    // Optional: Add items
    $items = [];
    foreach ($order->get_items() as $item) {
        $product = $item->get_product();
        if ($product) {
            $items[] = [
                'name'     => $product->get_name(),
                'quantity' => $item->get_quantity(),
                'price'    => $product->get_price(),
                'weight'   => $product->get_weight(),
            ];
        }
    }
    $shipment_payload['items'] = $items;

    $store_origin = get_option('oes_store_address', []);

    $payload = [
        "id" => $oes_order_id,
        "description" => "parcel",
        "extra_description" => "",
        "extra_charges" => 0,
        "extra_charges_currency" => 1,
        "option" => $selected_option_id,
        "objects" => [[
            "quantity" => 0,
            "weight" => 0,
            "unit_value" => 0,
            "value" => 0
        ]],
        "sender" => [
            "document_type_id" => 2,
            "name" => $store_origin['name'] ?? 'One Easy Stop',
            "lastname" => 'by One Easy Stop',
            "document" => "23232",
            "email" => $store_origin['email'],
            "phone" => $store_origin['phone'],
            "zip" => $store_origin['postal_code'] ?? '',
            "address" => $store_origin['address'] ?? ''
        ],
        "receiver" => [
            "document_type_id" => 9,
            "name" => $order->get_shipping_first_name(),
            "lastname" => $order->get_shipping_last_name(),
            "document" => "22334",
            "email" => $order->get_billing_email(),
            "phone" => $order->get_billing_phone(),
            "zip" => $order->get_shipping_postcode(),
            "address" => $order->get_shipping_address_1()
        ],
        "payment_method" => 1,
        "transaction" => [
            "code" => $order->get_transaction_id(),
            "amount" => floatval($shipping_data['cost']),
            "payment_method" => $order->get_payment_method(),
            "transaction_code" => $order->get_customer_id(),
            "currency" => 1
        ],
        "controller" => "order",
        "action" => "generate_website"
    ];

    // Fetch the token again (or reuse)
    $token = WC()->session->get(self::$token_key);
    if(!$token){
        self::oes_fetch_token();
        $token = WC()->session->get(self::$token_key);
    }
    
    $response = wp_remote_post('https://staging-api.oneeasystop.com/api/createShipment', [
        'headers' => [
            'Authorization' => 'Bearer ' . $token,
            'Content-Type'  => 'application/json',
            'Accept'        => 'application/json',
        ],
        'body' => json_encode($payload),
        'timeout' => 15,
    ]);

    if (is_wp_error($response)) {
        error_log('Shipment creation failed: ' . $response->get_error_message());
        return;
    }

    $body = json_decode(wp_remote_retrieve_body($response), true);
    
    // Optional: Store tracking in order meta
    if (!empty($body['website_order']['api_tracking']) || !empty($body['website_order']['api_reference'])) {
        $tracking_number = $body['website_order']['api_tracking'];
        if(empty($tracking_number) || $tracking_number ==''){
            $tracking_number = $body['website_order']['api_reference'];
        }
        $order->update_meta_data('oes_tracking_number', $tracking_number);
        $order->update_meta_data('oes_label', $body['website_order']['provider_label']);
        $order->update_meta_data('oes_invoice', $body['website_order']['invoice']);
        $order->update_meta_data('oes_provider_logo', $body['website_order']['provider']['image']['url']);


//         $shipping_items = $order->get_items('shipping');

// foreach ($shipping_items as $item_id => $shipping_item) {
//     wc_add_order_item_meta($item_id, '_oes_tracking_number', $tracking_number);
//     wc_add_order_item_meta($item_id, '_oes_label', $body['website_order']['provider_label']);
//     wc_add_order_item_meta($item_id, '_oes_invoice', $body['website_order']['invoice']);
// }
        
        $order->save();
    }
    if(!empty($body['website_order'])){
        WC()->session->set('shipment_order_status', 'created');
    }
    

}

}
