<?php
// Add admin menu
add_action('admin_menu', 'oes_plugin_admin_menu');
function oes_plugin_admin_menu() {
    add_menu_page(
        'Shipping Origin Settings',
        'OES Settings',
        'manage_options',
        'oes-plugin-settings',
        'oes_plugin_settings_page'
    );
}

// Enqueue Google Places API and custom JS
add_action('admin_enqueue_scripts', function($hook) {
    if ($hook === 'toplevel_page_oes-plugin-settings') {
        $google_api_key = 'AIzaSyDpdNGnKRQ5lzRm9BB6PHSwYP9t5AUxb_k';
        wp_enqueue_script('google-places', 'https://maps.googleapis.com/maps/api/js?key='.$google_api_key.'&libraries=places', [], null, true);
        wp_enqueue_script('oes-autocomplete', plugin_dir_url(__FILE__) . '../js/admin-autocomplete.js', ['google-places'], null, true);
    }
});

// Display settings page
function oes_plugin_settings_page() {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && check_admin_referer('oes_save_settings')) {
        $address = [
            'address'         => sanitize_text_field($_POST['store_address']),
            'city'            => sanitize_text_field($_POST['store_city']),
            'city_code'       => sanitize_text_field($_POST['store_city_code']),
            'state'           => sanitize_text_field($_POST['store_state']),
            'state_code'      => sanitize_text_field($_POST['store_state_code']),
            'country'         => sanitize_text_field($_POST['store_country']),
            'country_code'    => sanitize_text_field($_POST['store_country_code']),
            'postal_code'     => sanitize_text_field($_POST['store_postal_code']),
            'email'     => sanitize_text_field($_POST['store_email']),
            'phone'     => sanitize_text_field($_POST['store_phone']),
            'name'     => sanitize_text_field($_POST['store_name']),
            'client_id'     => sanitize_text_field($_POST['store_client_id']),
            'client_secret'     => sanitize_text_field($_POST['store_client_secret']),

            
        ];
        update_option('oes_store_address', $address);
        echo '<div class="updated"><p>Shipping address saved.</p></div>';
    }

    $saved = get_option('oes_store_address', []);
    ?>
    <div class="wrap">
        <h2>Set Default Shipping Origin Address for Store</h2>
        <form method="post">
            <?php wp_nonce_field('oes_save_settings'); ?>
            <table class="form-table">
            <tr>
                    <th><label for="store_name">Store Name</label></th>
                    <td>
                        <input type="text" name="store_name" id="store_name" value="<?= esc_attr($saved['name'] ?? '') ?>" class="regular-text" required>
                    </td>
                </tr>
                <tr>
                    <th><label for="store_email">Email</label></th>
                    <td>
                        <input type="text" name="store_email" id="store_email" value="<?= esc_attr($saved['email'] ?? '') ?>" class="regular-text" required>
                    </td>
                </tr>
                <tr>
                    <th><label for="store_phone">Phone</label></th>
                    <td>
                        <input type="text" name="store_phone" id="store_phone" value="<?= esc_attr($saved['phone'] ?? '') ?>" class="regular-text" required>
                    </td>
                </tr>
                <tr>
                    <th><label for="store_address">Address</label></th>
                    <td>
                        <input type="text" name="store_address" id="store_address" value="<?= esc_attr($saved['address'] ?? '') ?>" class="regular-text" required>
                    </td>
                </tr>
                <tr>
                    <th><label for="store_city">City</label></th>
                    <td>
                        <input type="text" name="store_city" id="store_city" value="<?= esc_attr($saved['city'] ?? '') ?>" class="regular-text" required>
                        <input type="hidden" name="store_city_code" id="store_city_code" value="<?= esc_attr($saved['city_code'] ?? '') ?>">
                    </td>
                </tr>
                <tr>
                    <th><label for="store_state">State</label></th>
                    <td>
                        <input type="text" name="store_state" id="store_state" value="<?= esc_attr($saved['state'] ?? '') ?>" class="regular-text" required>
                        <input type="hidden" name="store_state_code" id="store_state_code" value="<?= esc_attr($saved['state_code'] ?? '') ?>">
                    </td>
                </tr>
                <tr>
                    <th><label for="store_country">Country</label></th>
                    <td>
                        <input type="text" name="store_country" id="store_country" value="<?= esc_attr($saved['country'] ?? '') ?>" class="regular-text" required>
                        <input type="hidden" name="store_country_code" id="store_country_code" value="<?= esc_attr($saved['country_code'] ?? '') ?>">
                    </td>
                </tr>
                <tr>
                    <th><label for="store_postal_code">Postal Code</label></th>
                    <td>
                        <input type="text" name="store_postal_code" id="store_postal_code" value="<?= esc_attr($saved['postal_code'] ?? '') ?>" class="regular-text" required>
                    </td>
                </tr>
                <tr>
                    <th><label for="store_client_id">Client ID</label></th>
                    <td>
                        <input type="text" name="store_client_id" id="store_client_id" value="<?= esc_attr($saved['client_id'] ?? '') ?>" class="regular-text" required>
                    </td>
                </tr>
                <tr>
                    <th><label for="store_client_secret">Client Secret</label></th>
                    <td>
                        <input type="text" name="store_client_secret" id="store_client_secret" value="<?= esc_attr($saved['client_secret'] ?? '') ?>" class="regular-text" required>
                    </td>
                </tr>
            </table>
            <?php submit_button('Save Address'); ?>
        </form>
    </div>
    <?php
}
